﻿/**********************************
* @file adc.c
* @brief
* @author
* @version V0.0.0
* @date 2020.02.19
* @details 
* @copyright
* @note 
**********************************/

/* Includes ------------------------------------------------------------------*/

#include "CSU38F20.h"
#include "adc.h"
#include "isp.h"

/* Fuction Declare ----------------------------------------------------------*/

/***********************************
* @fn  void adc_init(void)
* @brief ADC init.
* @param[out] none.
* @param[in] none.
* @return none.
************************************/
void adc_init(void);

/***********************************
* @fn  static void delay_us(void)
* @brief delay time.
* @param[out] none.
* @param[in] none.
* @return none.
************************************/
static void delay_us(void);

/***********************************
* @fn  unsigned int adc_get_result(void)
* @brief get ADC result .
* @param[out] result.
* @param[in] channel.
* @return none.
************************************/
unsigned int adc_get_result(unsigned char channel);

/***********************************
* @fn  static void delay_us(void)
* @brief delay time.
* @param[out] none.
* @param[in] none.
* @return none.
************************************/

static void delay_us(void)
{
	unsigned char j;
	for(j = 250;j > 0;j--);
}

/***********************************
* @fn  void adc_init(void)
* @brief ADC init.
* @param[out] none.
* @param[in] none.
* @return none.
************************************/

void adc_init(void)
{
	set_adc_clk(); //ADC时钟为cpuclk/4，1MHz
	set_adc_samp(); //采样时间为4个ADC时钟
  	OFTEN = 0;
  	CALIF = 0;		//未开启校准
//	SROFTL = read_flash(0xFC0C);		//读取校准值
//	SROFTH = 0;
//	CALIF = 1;		//开启校准
  	ENOV = 0;
  	OFFEX = 0; 
//  	adc_int_enable();
  	adc_enable();
}

/***********************************
* @fn  unsigned int adc_get_result(void)
* @brief get ADC result .
* @param[out] result.
* @param[in] channel.
* @return none.
************************************/
unsigned int adc_get_result(unsigned char channel)
{
	static unsigned char conver_times = 0;
	static unsigned int result = 0;
	static unsigned char mode = 3;
	static unsigned int result_temp = 0;
	adc_channel(channel);
	SARVCMSEL = 0;		//差分采样共模电压小于1/2VREFF或单端采样时置0，否则置1
	delay_us();
	switch(mode)
	{
		case 0:			 //vref:VDD
		{ 
			VREFS_0 = 0;
			VREFS_1 = 0;
		}break;
		
		case 1:			 //vref:PT3.0
		{
			PT3EN_0 = 0;	//PT3.0为模拟输入口
			PT3PU_0 = 0;
			PT3CON_0 = 1;
			
			VREFS_0 = 1;
			VREFS_1 = 0;
		}break;
		
		case 2:			//vref:内部基准1.22V
		{
			VREFS_0 = 0;
			VREFS_1 = 1;
		}break;
		
		case 3:			//反测，需要将采样通道设为内部1/8VDD或内部参考电压1.22V
		{
			VREFS_0 = 0;
			VREFS_1 = 0;
		}break;
		
		default : mode = 0;
	}
	
	for(conver_times = 0; conver_times < 8; conver_times++)
	{
		adc_start_conver();
		while(SRADS);
		result = (SRADH << 8) | SRADL; //获取转换结果
		result_temp += result;
	}
	
	conver_times = 0;
	result = result_temp >> 3;
	result_temp = 0;

	return result;
}

